/*____________________________________________________________________________
		Copyright (C) 2000 Network Associates, Inc.
        All rights reserved.

        $Id: CMessageBox.cpp,v 1.3 1999/12/12 07:08:56 nryan Exp $
____________________________________________________________________________*/

#include "pgpClassesConfig.h"

#include "CMessageBox.h"
#include "CString.h"

_USING_PGP

// Class CMessageBox member functions

CMessageBox::Button 
CMessageBox::Display(
	const char	*message, 
	const char	*title, 
	HWND		parentWindow, 
	Tone		tone, 
	Style		style, 
	Button		focus) const
{
	pgpAssertStrValid(message);

	MSGBOXPARAMS	mbParams;

	mbParams.cbSize				= sizeof(MSGBOXPARAMS);
	mbParams.hwndOwner			= parentWindow;
	mbParams.hInstance			= NULL;
	mbParams.lpszText			= message;
	mbParams.lpszCaption		= title;
	mbParams.lpszIcon			= NULL;
	mbParams.dwContextHelpId	= NULL;
	mbParams.lpfnMsgBoxCallback	= NULL;
	mbParams.dwLanguageId		= MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT);

	PGPUInt32	flags	= MB_SETFOREGROUND;
	PGPUInt32	button, toneFlag;

	switch (tone)
	{
	case kWarningTone:
		toneFlag = MB_ICONWARNING;
		break;

	case kInfoTone:
		toneFlag = MB_ICONINFORMATION;
		break;

	case kQuestionTone:
		toneFlag = MB_ICONQUESTION;
		break;

	case kStopTone:
		toneFlag = MB_ICONSTOP;
		break;

	default:
		pgpAssert(FALSE);
		break;
	}

	switch (style)
	{
	case kOkStyle:
		flags |= MB_OK | toneFlag;
		break;

	case kOkCancelStyle:
		switch (focus)
		{
		case kOkButton:
			button = MB_DEFBUTTON1;
			break;

		case kCancelButton:
			button = MB_DEFBUTTON2;
			break;

		default:
			pgpAssert(FALSE);
			break;
		}
		
		flags |= button | MB_OKCANCEL | toneFlag;
		break;

	case kYesNoStyle:
		switch (focus)
		{
		case kYesButton:
			button = MB_DEFBUTTON1;
			break;

		case kNoButton:
			button = MB_DEFBUTTON2;
			break;

		default:
			pgpAssert(FALSE);
			break;
		}

		flags |= button | MB_YESNO | toneFlag;
		break;

	case kYesNoCancelStyle:
		switch (focus)
		{
		case kYesButton:
			button = MB_DEFBUTTON1;
			break;

		case kNoButton:
			button = MB_DEFBUTTON2;
			break;

		case kCancelButton:
			button = MB_DEFBUTTON3;
			break;

		default:
			pgpAssert(FALSE);
			break;
		}

		flags |= button | MB_YESNOCANCEL | toneFlag;
		break;

	default:
		pgpAssert(FALSE);
		break;
	}

	mbParams.dwStyle = flags;
	button = MessageBoxIndirect(&mbParams);

	// Finally return the choice the user made in the message box.
	switch (button)
	{
	case 0:
		THROW_PGPERROR(kPGPError_Win32WindowOpFailed);
		break;
	case IDYES:
		return kYesButton;
	case IDNO:
		return kNoButton;
	case IDOK:
		return kOkButton;
	default:
		return kCancelButton;
	}
}
